
function [mesh, pdecoef, matprop, params, bc, psi0] = beam(mesh,psi,params)

    %% geometry
    p = [ 0 , 0;
          2 , 0;
          2 , 1;
          0 , 1];
      
    g = [2; size(p,1); p(:,1); p(:,2)]; 

    % composing the geometry
    g = decsg(g);               
    
    %% mesh generation
    
    ghold = [];
    if isempty(mesh)
        [p,e,t] = poimesh(g,40,20); 
        [p,e,t] = refinemesh(g,p,e,t,'longest');            
        psi0 = -ones(size(p,2), 1);
    else
        p = mesh.p; e = mesh.e; t = mesh.t; 
        [p,e,t,psi] = refinemesh(g,p,e,t,psi,'longest');                      
        [p,e,t,psi] = refinemesh(g,p,e,t,psi,'longest');                      
        psi0 = psi;        
    end        
 
%     t(4,:) = 1; ghold = 2;
%     xt = pdeintrp(p,t,p(1,:)');
%     el = (xt <= 0.1); 
%     t(4,el) = ghold;
    area = pdetrg(p,t);
    mesh.p = p; 
    mesh.e = e; 
    mesh.t = t; 
    mesh.g = g;
    mesh.area  = area;
    mesh.ghold = ghold;     
    
    
    %% parameters
    % line-search procedure
    params.kmin = 1.0E-3;
    % stop criterion
    params.stop = 1.0*pi/180;
    % volume penalization
    params.penalty = 3.5; 
  
    %% boundary conditions
    
    bc.pNeu = [];  
    % bc.pNeu = [node,dof,val]
    % node: node number
    % dof:  degree of freedom number
    % val:  value of the nodal load 

    x = p(1,:); y = p(2,:); eps = 0.01*sqrt(min(area));
    cx = 2.0; cy = 0.5;    
    node = find((x-cx).^2 + (y-cy).^2 < eps^2);
    bc.pNeu = [node, 2, -1];     
    
    bc.pDir = [];
    % bc.pDir = [node,dof,val]
    % node: node number
    % dof:  degree of freedom number
    % val:  value of the nodal constraint 
    
    cx = 0.0;      
    node = find(x < cx + eps); node = node';
    npb = size(node,1); node = [node;node]; 
    dof = [ones(npb,1);2*ones(npb,1)]; 
    val = [zeros(npb,1);zeros(npb,1)];
    bc.pDir = [node, dof, val];
    
    %% material properties

    E = 1.0; gamma = 1.0E-3; nu = 1/3;      
    la = nu*E/((1+nu)*(1-2*nu)); mu = E/(2*(1+nu)); % plane strain
    la = 2*mu*la/(la+2*mu); % plane stress  
    matprop.la = la; matprop.mu = mu; matprop.gamma = gamma;  

    %% pde coeficients
    
    c = zeros(10,1);
    c(1,:) = 2*mu + la; c(3,:) = mu;  c(5,:) = mu;
    c(6,:) = la; c(8,:) = mu; c(10,:) = 2*mu + la;
    
    pdecoef.c = c; pdecoef.a = zeros(4,1);    

end
