
function [mesh, pdecoef, matprop, params, bc, psi0] = tbar(mesh,psi,params)

    %% geometry
    p = [ 0 , 0;
          1 , 0;
          1 , 1;
          0 , 1];
      
    g = [2; size(p,1); p(:,1); p(:,2)]; 

    % composing the geometry
    g = decsg(g);               
    
    %% mesh generation
    
    ghold = [];
    if isempty(mesh)
        [p,e,t] = poimesh(g,20,20); 
        [p,e,t] = refinemesh(g,p,e,t,'longest');            
        psi0 = -ones(size(p,2), 1);
    else
        p = mesh.p; e = mesh.e; t = mesh.t; 
        [p,e,t,psi] = refinemesh(g,p,e,t,psi,'longest');                      
        [p,e,t,psi] = refinemesh(g,p,e,t,psi,'longest');                      
        psi0 = psi;        
    end        
 
    area = pdetrg(p,t);
    mesh.p = p; 
    mesh.e = e; 
    mesh.t = t; 
    mesh.g = g;
    mesh.ghold = ghold;
    mesh.area  = area;     
    
    %% parameters
    % line-search procedure
    params.kmin = 1.0E-3;
    % stop criterion
    params.stop = 1.0*pi/180;
    % volume penalization
    params.penalty = 2.75;
  
    %% boundary conditions
    
    bc.pNeu = [];  
    % bc.pNeu = [node,dof,val]
    % node: node number
    % dof:  degree of freedom number
    % val:  value of the nodal load     
    
    bc.pDir = [];
    % bc.pDir = [node,dof,val]
    % node: node number
    % dof:  degree of freedom number
    % val:  value of the nodal constraint 
    
    x = p(1,:); y = p(2,:); 
    eps = 0.1*sqrt(min(area));
  
    cx = 0.0; 
    node = find(x < cx + eps); aux = size(node,2); node = node'; 
    dof = ones(aux,1); val = zeros(aux,1);
    pDir1 = [node, dof, val];
    
    cy = 0.0;    
    node = find(y < cy + eps); aux = size(node,2); node = node'; 
    dof = 2*ones(aux,1); val = zeros(aux,1);
    pDir2 = [node, dof, val];

    bc.pDir = [pDir1; pDir2];    
    
    cx = 1.0; cy = 0.5;    
    node = find(and(x > cx - eps,y < cy + eps)); aux = size(node,2); node = node'; 
    dof = ones(aux,1); val = ones(aux,1); val(1) = val(1)/2; val(aux) = val(aux)/2;
    bc.pNeu = [node, dof, val];    
    

    %% material properties
    
    E = 1.0; gamma = 1.0E-3; nu = 1/3; 
    la = nu*E/((1+nu)*(1-2*nu)); mu = E/(2*(1+nu)); % plane strain
    la = 2*mu*la/(la+2*mu); % plane stress  
    matprop.la = la; matprop.mu = mu; matprop.gamma = gamma;  

    %% pde coeficients
    
    c = zeros(10,1);
    c(1,:) = 2*mu + la; c(3,:) = mu;  c(5,:) = mu;
    c(6,:) = la; c(8,:) = mu; c(10,:) = 2*mu + la;
    
    pdecoef.c = c; pdecoef.a = zeros(4,1);    

end
