
function [mesh, pdecoef, matprop, params, bc, psi0] = hand(mesh,psi,params)

    %% geometry
    p = [ 0 , 0;
          1 , 0;
          1 , 1;
          0 , 1];
      
    g = [2; size(p,1); p(:,1); p(:,2)]; 

    % composing the geometry
    g = decsg(g);               
    
    %% mesh generation
    
    ghold = [];
    if isempty(mesh)
        [p,e,t] = poimesh(g,20,20); 
        [p,e,t] = refinemesh(g,p,e,t,'longest');            
        psi0 = -ones(size(p,2), 1);
    else
        p = mesh.p; e = mesh.e; t = mesh.t; 
        [p,e,t,psi] = refinemesh(g,p,e,t,psi,'longest');                      
        [p,e,t,psi] = refinemesh(g,p,e,t,psi,'longest');                      
        psi0 = psi;        
    end        
 
    mesh.p = p; 
    mesh.e = e; 
    mesh.t = t; 
    mesh.g = g;
    mesh.ghold = ghold;
    mesh.area  = pdetrg(p,t);     
    
    %% parameters
    % line-search procedure
    params.kmin = 1.0E-3;
    % stop criterion
    params.stop = 1.0*pi/180;
    % volume penalization
    params.penalty = 2.5;
  
    %% boundary conditions
    
    bc.pNeu = [];  
    % bc.pNeu = [node,dof,val]
    % node: node number
    % dof:  degree of freedom number
    % val:  value of the nodal load 

    x = p(1,:); y = p(2,:);
    R2 = 0.001^2; cx = 1.0; cy = 1.0;    
    node = find((x-cx).^2 + (y-cy).^2 < R2);
    bc.pNeu = [node, 2, -10];     
    
    bc.pDir = [];
    % bc.pDir = [node,dof,val]
    % node: node number
    % dof:  degree of freedom number
    % val:  value of the nodal constraint 

    cx = 0.0; cy = 1.0;    
    node = find((x-cx).^2 + (y-cy).^2 < R2);
    pDir1 = [[node;node], [1;2], [0;0]];
    
    cx = 0.0; cy = 0.0;    
    node = find((x-cx).^2 + (y-cy).^2 < R2);
    pDir2 = [[node;node], [1;2], [0;0]];
    bc.pDir = [pDir1; pDir2];    

    %% material properties

    E = 1.0; gamma = 1.0E-3; nu = 1/3;      
    la = nu*E/((1+nu)*(1-2*nu)); mu = E/(2*(1+nu)); % plane strain
    la = 2*mu*la/(la+2*mu); % plane stress  
    matprop.la = la; matprop.mu = mu; matprop.gamma = gamma;  

    %% pde coeficients
    
    c = zeros(10,1);
    c(1,:) = 2*mu + la; c(3,:) = mu;  c(5,:) = mu;
    c(6,:) = la; c(8,:) = mu; c(10,:) = 2*mu + la;
    
    pdecoef.c = c; pdecoef.a = zeros(4,1);    

end
